--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNworldStatistics ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNgatherWorldInfo =
  (
    local LOCworldInfo = #(#(),#())
    local LOCotherInfo = #(0,0)

    if DYNworldStatistics.open == true then
    (
      DYNworldStatistics.dnWorld.items.clear()

      --- Count up Vertices and Faces for every object in the scene and put into various arrays
      local LOCnodeArray     = DYNFUNgetCivilViewCategorizedNodeArrays "nodes" false
      local LOClistItemRange = #() --array to collect the list items

      for i = 1 to DYNcivilViewCategoryCount do
      (
        append LOCworldInfo[1] 0
        append LOCworldInfo[2] 0

        for ii in LOCnodeArray[i] do
        (
          LOCworldInfo[1][i] += (getPolygonCount ii)[1]     -- Count Number of Faces
          LOCworldInfo[2][i] += (getPolygonCount ii)[2]     -- Count Number of Vertices
        )

        --- dOTnet vERSION
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesObjClasses[i] + " (" + (LOCnodeArray[i].count as string) + ")")
        local LOCsubItem  = LOClistItem.SubItems.add (LOCworldInfo[DYNworldStatistics.DDDYNlistType.selection][i] as string)
        LOClistItem.ImageIndex = i
        append LOClistItemRange LOClistItem --we add the list item to the array
      )

      for i = 16 to 20 do
      (
        for ii in LOCnodeArray[i] do
        (
          LOCotherInfo[1] += (getPolygonCount ii)[1]     -- Count Number of Faces
          LOCotherInfo[2] += (getPolygonCount ii)[2]     -- Count Number of Vertices
        )
      )

      --- Calculate Totals for VSP Objects
      local LOCvspTotal = 0
      local LOCinfoTotal = #(0,0)
      for i = 1 to DYNcivilViewCategoryCount do LOCvspTotal += LOCnodeArray[i].count
      for i = 1 to LOCworldInfo[1].count do LOCinfoTotal[1] += LOCworldInfo[1][i]
      for i = 1 to LOCworldInfo[2].count do LOCinfoTotal[2] += LOCworldInfo[2][i]

      --- Calculate Totals For Non-VSP Objects
      local LOCnonVspTotal = 0
      for i = 16 to 20 do LOCnonVspTotal += LOCnodeArray[i].count
      LOCinfoTotal[1] += LOCotherInfo[1] -- Add face totals for non-VSP objects
      LOCinfoTotal[2] += LOCotherInfo[2] -- Add vertex totals for non-VSP objects

      --- dOTnet vERSION
      local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[86] + " (" + (LOCnonVspTotal as string) + ")")
      local LOCsubItem  = LOClistItem.SubItems.add (LOCotherInfo[DYNworldStatistics.DDDYNlistType.selection] as string)
      LOClistItem.ImageIndex = 6
      append LOClistItemRange LOClistItem --we add the list item to the array

      --- Display Totals in Panel
      local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[19] + " (" + ((LOCvspTotal + LOCnonVspTotal) as string) + ")")
      local LOCsubItem  = LOClistItem.SubItems.add (LOCinfoTotal[DYNworldStatistics.DDDYNlistType.selection] as string)
      LOClistItem.font  = DYNdnBoldFont
      LOClistItem.ImageIndex = 44
      append LOClistItemRange LOClistItem --we add the list item to the array

      --- Update dotNET ListView
      DYNworldStatistics.dnWorld.Items.AddRange LOClistItemRange --when done, we populate the ListView
      DYNworldStatistics.dnWorld.refresh()
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  dropdownlist DDDYNlistType align:#center width:(DYNiniExplorerWidth - 23)

  dotNetControl  dnWorld "System.Windows.Forms.ListView" height:350 width:(DYNiniExplorerWidth - 23) align:#center

  button BUDYNupdate   width:(DYNiniExplorerWidth - 21) align:#center
  button BUDYNadvanced width:(DYNiniExplorerWidth - 21) align:#center

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNworldStatistics open do
  (
    DYNworldStatistics.title   = DYNuiRolloutNames[1]
    DDDYNlistType.items        = #(DYNuiResourcesLvColumns[10], DYNuiResourcesLvColumns[11])
    DDDYNlistType.selection    = 1

    BUDYNupdate.text           = DYNuiResourcesButtons[29]
    BUDYNadvanced.text         = DYNuiResourcesButtons[28]

    --- Set Up dotNET List View Control
    DYNFUNdnListViewStyle dnWorld false true
    dnWorld.multiSelect        = false
    dnWorld.AllowColumnReorder = false
    dnWorld.sorting            = DYNdnSortOrderClass.none
    dnWorld.smallImageList     = DYNdnSmImageList
    local LOCcol1 = dnWorld.Columns.add DYNuiResourcesLvColumns[9] 120
    LOCcol1.textAlign = DYNdnHorAlignClass.left
    if DDDYNlistType.selection == 1 then  -- Faces
    (
      local LOCcol3 = dnWorld.Columns.add DYNuiResourcesLvColumns[10] 60
      LOCcol3.textAlign = DYNdnHorAlignClass.right
    )
    else
    (                                     -- Vertices
      local LOCcol3 = dnWorld.Columns.add DYNuiResourcesLvColumns[11] 60
      LOCcol3.textAlign = DYNdnHorAlignClass.right
    )

    DYNFUNgatherWorldInfo()
  )

  on DYNworldStatistics close do
  (
    dnWorld.Items.clear()
  )

  on DDDYNlistType selected arg do
  (
    if arg == 1 then dnWorld.columns.item[1].text = DYNuiResourcesLvColumns[10]
    if arg == 2 then dnWorld.columns.item[1].text = DYNuiResourcesLvColumns[11]
    DYNFUNgatherWorldInfo()
  )

  on BUDYNupdate   pressed do DYNFUNgatherWorldInfo()
  on BUDYNadvanced pressed do (max file summary)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQDH7iTobBEwXV4dnS6m8sp4cW6LUlUa88aL
-- GGKGGE8ElClTJqP6u3teMJ1ATZvoPe8rmiZfchRGqacYe+73yonMMyymbVzgPk1m
-- mlHcyTTkbWllR2ZpWdQwEcpR5mOsaj1xZ9qJOrzqZJR/wisaDeDXixDdWVqJf7bd
-- sReT9J6ekQ41NtxBw5FzhWdO5ORZ2cpvw4TZCuAEcy5Pg58DEYiV1B3JgdewqStj
-- lZ5zj5KQHst8Lt559Sori9sT1ZcfYOCuwDEcU3Q/dw1nVJQgnJZ2gqjgs9iNHxtH
-- HVBvLRqcBGKc2ENE5KvaJlmdVYb4lx6fB3oOJxbaBWxYaAwLz+7c
-- -----END-SIGNATURE-----